<?php
// app/Models/SupplierRepository.php
namespace App\Models;

use App\Core\Database;
use App\Models\Entities\SupplierEntity;

class SupplierRepository extends BaseRepository
{
    public function __construct(Database $db)
    {
        parent::__construct($db, 'suppliers', SupplierEntity::class);
    }

    /**
     * Vytvoří nového dodavatele z pole dat (typicky z formuláře).
     * Vrací id vloženého záznamu.
     */
    public function create(array $data): int
    {
        $stmt = $this->pdo->prepare("INSERT INTO suppliers (name, email, phone, vip) VALUES (:name, :email, :phone, :vip)");
        $stmt->execute([
            'name'  => $data['name'],
            'email' => $data['email'] ?? null,
            'phone' => $data['phone'] ?? null, 
            'vip' => $data['vip'] ?? null
        ]);
        return (int)$this->pdo->lastInsertId();
    }

    /**
     * Aktualizuje dodavatele podle id.
     *
     * @param int $id
     * @param array $data
     * @return bool
     */
    public function update(int $id, array $data): bool
    {
        $stmt = $this->pdo->prepare("UPDATE suppliers SET name=:name, email=:email, phone=:phone, vip=:vip WHERE id=:id");
        return $stmt->execute([
            'name'  => $data['name'],
            'email' => $data['email'] ?? null,
            'phone' => $data['phone'] ?? null,
            'vip' => $data['vip'] ?? null,
            'id'    => $id
        ]);
    }
}